import yaml
from pathlib import Path
from collections import defaultdict


EntityDir = "entities/"


class Entities():

    def __init__(self):
        self.entities = Entities.GetEntities()

    @staticmethod
    def GetEntities(path=EntityDir):
        Entities = defaultdict()

        for path in Path("entities").glob("*.yml"):
            with open(path) as f:
                # use safe_load instead load
                dataMap = yaml.safe_load(f)
                Entities[path.stem] = dataMap

        return Entities
    
    def GetEntitySubset(self, subset=[]):
        if subset:
            dict((k, self.entities[k]) for k in subset if k in self.entities)
        else:
            return self.entities
    
    def FindFunction(self, function_name, entity):
        target_entity = self.entities[entity]
        for statement in target_entity['statements']:
            if statement['name'] == function_name:
                return statement
        for entity in self.entities.values():
            for statement in entity['statements']:
                if statement['name'] == function_name:
                    return statement
        raise Exception("Didnt find statement in Entity")